#if !defined(_Pizarra_h)
#define _Pizarra_h

#include <strstream.h>
#include <string>
#include <stream.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <iostream.h>

#include "/usr/X11R6/include/X11/Xlib.h"
#include "/usr/X11R6/include/X11/Xutil.h"

class ventana {

public:

  ventana(string="noname",int=500,int=500,int=5,int=500,int=1);
  ~ventana();



  void axes_range(double,double,double,double,int,int,int,int,int=0);
  void axes_rangeR(double,double,double,double,int=0);
  void axes_rangeP(int,int,int,int,int=0);

  void axes(int,string ,string ,string );
  void axes(int,string ,string );
  void axes_titulo(int,string );
  void axes(int);
  void axes_lines(int);
  void axes_labels(int);
  
  void wait();
  void wait(double);
  void flush();
  void clean(int=0);
  void clean(int,int,int,int);

  int px(double,int);
  int py(double,int);

  void color_set(double,double,double);
  void color_set(int);


  void save(string);

  void plot_text(int,int,string );
  void plot_text(int,int,double);
  void plot_point(double,double,int=0);
  void plot_point(double [],double [],int,int=0);
  void plot_point(double [],int,int=0);
  void plot_line(double,double,double,double,int=0);
  void plot_line(double [],double [],int,int=0);
  void plot_line(double [],int,int=0);

  void plot(double [],double [],int);

  void plot_rectangle(double,double,double,double,int);
  void plot_rectangle(int,int,int,int);
  void plot_rectangle_fill(double,double,double,double,int);
  void plot_rectangle_fill(int,int,int,int);
  void plot_bar(double [],double [],int,double,int=0);
  void plot_bar(double [],int,int=0);
  void plot_arrow(double,double,double,double,double,int=0);

  void plot2d_den(double **,int,int,double,double,int);
  void plot2d_den(double **,double *,double *,int,int,double,double,int);
  void plot2d_colorx(int,int,int,int,double,double,string );
  void plot2d_colory(int,int,int,int,double,double,string );
  void plot2d_vec(double **,double **,int,int,double,int,int=0);
  void plot2d_vec(double **,double **,double *,double *,int,int,double,int,int=0);


private:

  Display *mydisplay;
  int myscreen;
  Window mywindow;
  GC mygc;
  int winID;


  unsigned long background;
  unsigned long foreground;
  unsigned long colorbase;
  unsigned long colorred;
  unsigned long colorgre;
  unsigned long colorblu;
  unsigned long colorpixel;
  
  

  unsigned int width; 
  unsigned int height;
  unsigned int numgraph;

  int twx;         // Text width in x
  int twy;         // Text width in y

  int * xiP;
  int * yiP;
  int * xfP;
  int * yfP;
  int * anchoxP;
  int * anchoyP;

  double * xiR;
  double * yiR;
  double * xfR;
  double * yfR;
  double * anchoxR ;
  double * anchoyR ;

};


#endif
