#include <iostream.h>
#include <math.h>
#include "ventana.h"

int main(){


  int nr = 500;
  int nt = 500;
  int nit= 1000;

  double xN,lambda;


  ventana xwin("Ecuacion logistica",500,500,5,0,3);


  double *x1 = new double[nt];
  double *y1 = new double[nt];


  xwin.axes_range(0.0,4.0,0.0,1.0,30,450,25,175,1);
  xwin.color_set(1);
  xwin.axes(1,"Mapa Logistico","r","x");
  for (int j=0;j<=nr;j++){
    lambda = 0.0 + 4.0*j/double(nr);
    xN     = 0.314159;
    for (int i=0;i<nit;i++) xN = lambda*xN*(1.0-xN);
    y1[0] = xN;
    for (int i=1;i<nt;i++) y1[i] = lambda*y1[i-1]*(1.0-y1[i-1]);
    for (int i=0;i<nt;i++) x1[i] = lambda;
    xwin.color_set(0,0,lambda/4.0);
    xwin.plot_point(x1,y1,nt,1);
  }  



  int n = 50;
  double ** vx;
  vx        = new double*[n+1];
  for (int i=0;i<n+1;i++) vx[i] = new double[n+1];
  double ** vy;
  vy        = new double*[n+1];
  for (int i=0;i<n+1;i++) vy[i] = new double[n+1];
  double *x = new double[n+1];
  double *y = new double[n+1];
  for (int i=0;i<n+1;i++) x[i] = double(i)/50.0;
  for (int j=0;j<n+1;j++) y[j] = double(j)/50.0;
  for (int i=0;i<n+1;i++){
    for (int j=0;j<n+1;j++){
      vx[i][j] = sin(2.0*3.1415*x[i]*y[j]);
      vy[i][j] = cos(2.0*3.1415*x[i]*y[j]);
    }
  }  





  xwin.axes_range(0,1,0,1,30,230,250,450,2);
  xwin.color_set(1);
  xwin.axes(2,"Sin[2 Pi x y]","x","y");
  xwin.plot2d_den(vx,x,y,n+1,n+1,-1.0,1.0,2);
  xwin.plot2d_colorx(30,220,230,230,-1.0,1.0,"A");



  xwin.axes_range(0,1,0,1,280,480,250,450,3);
  xwin.color_set(1);
  xwin.axes(3,"x","y");
  xwin.axes_titulo(3,"Vx & Vy");
  xwin.plot2d_vec(vx,vy,x,y,n+1,n+1,1.0,5,3);

  xwin.flush();
  xwin.wait() ;
}
