#include "ventana.h"


//////////////////////////////////////////
// CONSTRUCTOR
//////////////////////////////////////////

ventana::ventana(string nombre, int xSize, int ySize,int xpos,int ypos,int numgra){

  width    = xSize;
  height   = ySize;
  numgraph = numgra+1;

  twx       = 25;
  twy       = 10;

  xiP     = new int[numgraph];
  yiP     = new int[numgraph];
  xfP     = new int[numgraph];
  yfP     = new int[numgraph];
  anchoxP = new int[numgraph];
  anchoyP = new int[numgraph];

  xiR     = new double[numgraph];
  yiR     = new double[numgraph];
  xfR     = new double[numgraph];
  yfR     = new double[numgraph];
  anchoxR = new double[numgraph];
  anchoyR = new double[numgraph];



  // Definition window on n=0

  xiP[0]   = 0;
  xfP[0]   = width;
  yiP[0]   = height;
  yfP[0]   = 0;
  xiR[0]   = 0; 
  xfR[0]   = width;
  yiR[0]   = 0;
  yfR[0]   = height;
  anchoxP[0] = width;
  anchoyP[0] = height;
  anchoxR[0] = width;
  anchoyR[0] = height;


  unsigned int border_width  = 5 ;


  // initialize window, display, screen
  // ----------------------------------

  mydisplay=XOpenDisplay("") ;
  if(mydisplay ==NULL){
      cout <<"*** can't connect to server"<< endl ;
      exit(0) ;
  }
  myscreen=DefaultScreen(mydisplay) ;


  foreground = BlackPixel(mydisplay,myscreen);
  background = WhitePixel(mydisplay,myscreen);  

  mywindow = XCreateSimpleWindow( mydisplay,
				  DefaultRootWindow(mydisplay), 
				  xpos, ypos, width, height,
				  border_width, foreground, background) ;



  


  // redraw window when in focus
  // ---------------------------

  XSetWindowAttributes setwinattr ;
  unsigned long valuemask;
  valuemask =CWBackingStore ;
  setwinattr.backing_store=Always ;  
  XChangeWindowAttributes(mydisplay, mywindow, valuemask, &setwinattr);

  XStoreName(mydisplay, mywindow, nombre.c_str()) ;
  XSetIconName(mydisplay, mywindow, nombre.c_str()) ;
  mygc = XCreateGC(mydisplay, mywindow, 0 ,0) ;
  XSelectInput(mydisplay, mywindow,ExposureMask | ButtonPressMask) ;   
  XMapRaised(mydisplay, mywindow) ;
  XFlush(mydisplay) ;


  // initialize color table
  // ----------------------

  Colormap cmap= DefaultColormap( mydisplay,  myscreen );
  XColor mycolor;
  mycolor.red  = 0;
  mycolor.green= 0;
  mycolor.blue = 0;
  XAllocColor(mydisplay, cmap, &mycolor);
  colorbase    = mycolor.pixel;
  mycolor.red  = 65535;
  XAllocColor(mydisplay, cmap, &mycolor);
  colorred     = mycolor.pixel;
  mycolor.red  = 0;
  mycolor.green= 65535;
  XAllocColor(mydisplay, cmap, &mycolor);
  colorgre     = mycolor.pixel;
  mycolor.green= 0;
  mycolor.blue = 65535;
  XAllocColor(mydisplay, cmap, &mycolor);
  colorblu     = mycolor.pixel;

  winID = mywindow;

}


//////////////////////////////////////////
// DESTRUCTOR
//////////////////////////////////////////

ventana::~ventana(){
  XFreeGC(mydisplay, mygc) ;
  XDestroyWindow(mydisplay, mywindow) ;
  XCloseDisplay(mydisplay) ;

  delete [] xiP;
  delete [] yiP;
  delete [] xfP;
  delete [] yfP;
  delete [] anchoxP;
  delete [] anchoyP;

  delete [] xiR ;
  delete [] yiR ;
  delete [] xfR;
  delete [] yfR;
  delete [] anchoxR;
  delete [] anchoyR;
}




//////////////////////////////////////////
// HANDLES COLORS
//////////////////////////////////////////


void ventana::color_set(double r1,double g1, double b1){
  colorpixel = colorbase + 
    (unsigned long)(colorblu*b1) +
    (unsigned long)(colorblu*g1+1)*(colorblu+1) + 
    (unsigned long)(colorblu*r1+1)*(colorgre+colorblu+1);
  XSetForeground(mydisplay, mygc, colorpixel);
}
// void ventana::color_set(double r1,double g1,double b1){
//   mycolor.red =  (fabs(r1)>1)? 65535: int(65535*fabs(r1)) ;
//   mycolor.green= (fabs(g1)>1)? 65535: int(65535*fabs(g1)) ;
//   mycolor.blue=  (fabs(b1)>1)? 65535: int(65535*fabs(b1)) ;
//   XAllocColor(mydisplay, cmap, &mycolor);
//   XSetForeground(mydisplay, mygc, mycolor.pixel );
// }
void ventana::color_set(int i){
  if (i ==0) XSetForeground(mydisplay,mygc,background);
  if (i ==1) XSetForeground(mydisplay,mygc,foreground);
}




//////////////////////////////////////////
// POSITIONS GRAPHS VARIABLES IN PIXELS
//////////////////////////////////////////

int ventana::px(double x,int n){
  int rX=xiP[n]+int((x-xiR[n])*double(anchoxP[n])/anchoxR[n]);
  if(rX<xiP[n]) rX=xiP[n];
  if(rX>xfP[n]) rX=xfP[n];
  return rX;
}
int ventana::py(double y,int n){
  int rY=yiP[n]-int((y-yiR[n])*double(anchoyP[n])/anchoyR[n]);
  if(rY<yfP[n]) rY=yfP[n];
  if(rY>yiP[n]) rY=yiP[n];
  return rY;
}



//////////////////////////////////////////
// DRAW AXES AND LABELS
//////////////////////////////////////////

void ventana::axes(int n){
  axes_lines(n);
  axes_labels(n);
}
void ventana::axes(int n,string t1,string t2){
  axes_lines(n);
  axes_labels(n);
  plot_text(xiP[n]+anchoxP[n]/2,yiP[n]+twy,t1);
  plot_text(xiP[n]-twx,yfP[n]+anchoyP[n]/2,t2);
}
void ventana::axes(int n,string t1,string t2,string t3){
  axes_lines(n);
  axes_labels(n);
  axes_titulo(n,t1);
  plot_text(xiP[n]+anchoxP[n]/2,yiP[n]+twy,t2);
  plot_text(xiP[n]-twx,yfP[n]+anchoyP[n]/2,t3);
}
void ventana::axes_titulo(int n,string t1){
  plot_text(xiP[n],yfP[n]-twy,t1);
}
void ventana::axes_range(double xi,double xf, double yi, double yf,
			 int nxi,int nxf,int nyi,int nyf,int n){
  axes_rangeR(xi,xf,yi,yf,n);
  axes_rangeP(nxi,nxf,nyi,nyf,n);
}
void ventana::axes_rangeR(double xi,double xf, double yi, double yf,int n){
  if (n>=numgraph || n<=0 || xf<=xi || yf<=yi){
    cout<<"Error en definicion de graficoR "<<n<<" of "<<numgraph<<endl; 
    exit(0);
  };
  xiR[n]   = xi; 
  xfR[n]   = xf;
  yiR[n]   = yi;
  yfR[n]   = yf;
  anchoxR[n] = fabs(xfR[n]-xiR[n]);
  anchoyR[n] = fabs(yfR[n]-yiR[n]);
}
void ventana::axes_rangeP(int nxi,int nxf,int nyi,int nyf,int n){
  if (n>=numgraph || n<=0 || nxf<=nxi || nyf<=nyi){
    cout<<"Error en definicion de graficoP "<<n<<" of "<<numgraph<<endl; 
    exit(0);
  };
  xiP[n]   = nxi;
  xfP[n]   = nxf;
  yiP[n]   = height-nyi;
  yfP[n]   = height-nyf;
  anchoxP[n] = xfP[n]-xiP[n];
  anchoyP[n] = -(yfP[n]-yiP[n]);
}
void ventana::axes_lines(int n){
  if (n >= numgraph){
    cout << " Error en numero de graficos"<< endl; 
    exit(0);
  }
  plot_rectangle(xiP[n],yiP[n],xfP[n],yfP[n]);
}
void ventana::axes_labels(int n){
  if (n >= numgraph){
    cout << " Error en numero de graficos"<< endl; 
    exit(0);
  }
  plot_text(xiP[n],yiP[n]+twy,xiR[n]);
  plot_text(xfP[n]-twx,yiP[n]+twy,xfR[n]);
  plot_text(xiP[n]-twx,yiP[n],yiR[n]);
  plot_text(xiP[n]-twx,yfP[n]+twy,yfR[n]);
}





//////////////////////////////////////////
// DRAW 1D GRAPHS ELEMENTS
//////////////////////////////////////////

void ventana::plot_text(int i1,int j1,double d){
  ostrstream s;
  s<<d;
  XDrawString(mydisplay, mywindow, mygc,i1,j1,s.str(),s.pcount());
}
void ventana::plot_text(int i1,int j1,string s){
  XDrawString(mydisplay, mywindow, mygc,i1,j1,s.c_str(),s.length());
}





void ventana::plot_point(double x ,double y,int ng){
  XDrawPoint(mydisplay, mywindow, mygc, px(x,ng), py(y,ng));
}
void ventana::plot_point(double x[],double y[],int n,int ng){
  for (int i=0;i<n;i++) plot_point(x[i],y[i],ng);
}
void ventana::plot_point(double y[],int n,int ng){
  for (int i=0;i<n;i++) plot_point(i,y[i],ng);
}





void ventana::plot_line(double x1,double y1,double x2,double y2,int ng){
  XDrawLine(mydisplay, mywindow,mygc,px(x1,ng),py(y1,ng),px(x2,ng),py(y2,ng));
}

void ventana::plot_line(double x[],double y[],int n,int ng){
  for (int i=0;i<n-1;i++) plot_line(x[i],y[i],x[i+1],y[i+1],ng);
}
void ventana::plot_line(double y[],int n,int ng){
  for (int i=0;i<n-1;i++) plot_line(i,y[i],i+1,y[i+1],ng);
}



void ventana::plot(double x[],double y[],int n){
  double xmax = x[0];
  double xmin = x[0];
  double ymax = y[0];
  double ymin = y[0];
  for (int i=0;i<=n;i++){
    if (xmax<x[i]) xmax=x[i];
    if (xmin>x[i]) xmin=x[i];
    if (ymax<y[i]) ymax=y[i];
    if (ymin>y[i]) ymin=y[i];
  }
  axes_range(xmin,xmax,ymin,ymax,25,width-25,25,height-25,1);
  axes(1,"X","Y");
  for (int i=0;i<n;i++) plot_line(x[i],y[i],x[i+1],y[i+1],1);
}





void ventana::plot_rectangle(double x1,double y1,double x2,double y2,int ng){
  plot_rectangle(px(x1,ng),py(y1,ng),px(x2,ng),py(y2,ng));
}
void ventana::plot_rectangle_fill(double x1,double y1,double x2,double y2,int ng){
  plot_rectangle_fill(px(x1,ng),py(y1,ng),px(x2,ng),py(y2,ng));
}
void ventana::plot_rectangle(int xi,int yi,int xf,int yf){
  XDrawRectangle(mydisplay,mywindow,mygc,xi,yf,xf-xi,yi-yf);
}
void ventana::plot_rectangle_fill(int xi,int yi,int xf,int yf){
  XFillRectangle(mydisplay,mywindow,mygc,xi,yf,xf-xi,yi-yf);
}





void ventana::plot_bar(double x[],double y[],int n,double dx,int ng){
  for (int i=0;i<n;i++){
    plot_line(x[i]-dx,0.0,x[i]-dx,y[i],ng);
    plot_line(x[i]-dx,y[i],x[i]+dx,y[i],ng);
    plot_line(x[i]+dx,y[i],x[i]+dx,0.0,ng);
  }
}
void ventana::plot_bar(double y[],int n,int ng){
  for (int i=0;i<n;i++){
    plot_line(i-0.5,0.0,i-0.5,y[i],ng);
    plot_line(i-0.5,y[i],i+0.5,y[i],ng);
    plot_line(i+0.5,0.0,i+0.5,y[i],ng);
  }
}




void ventana::plot_arrow(double x1,double y1,double x2,double y2,double dx,int ng){
  plot_line(x1,y1,x2,y2,ng);
  double ang = 0.8*3.1415;
  double bx  = dx*((x2-x1)*cos(ang)-(y2-y1)*sin(ang));
  double by  = dx*((x2-x1)*sin(ang)+(y2-y1)*cos(ang));
  plot_line(x2,y2,x2+bx,y2+by,ng);
  ang = -ang;
  bx  = dx*((x2-x1)*cos(ang)-(y2-y1)*sin(ang));
  by  = dx*((x2-x1)*sin(ang)+(y2-y1)*cos(ang));
  plot_line(x2,y2,x2+bx,y2+by,ng);
}

//////////////////////////////////////////
// DRAW 2D GRAPHS ELEMENTS
//////////////////////////////////////////


void ventana::plot2d_den(double **z,int nx,int ny,double zmin,double zmax,int n){  
  double b;
  for (int i=0;i<nx;i++){
    for (int j=0;j<ny;j++){
      b  = (z[i][j]-zmin)/(zmax-zmin);
      color_set(b,0,0);
      plot_rectangle_fill(i-0.5,j-0.5,i+0.5,j+0.5,n);
    }
  }
  XSetForeground(mydisplay,mygc,colorpixel);
}
void ventana::plot2d_den(double **z,double *x,double *y,int nx,int ny,double zmin,double zmax,int n){  
  double b;
  double dx=(x[1]-x[0])/2.0;
  double dy=(y[1]-y[0])/2.0;
  for (int i=0;i<nx;i++){
    for (int j=0;j<ny;j++){
      b  = (z[i][j]-zmin)/(zmax-zmin);
      if (b>=0 && b <=1) color_set(b,0,0);
      else {
	if (b>1) color_set(0);
	if (b<0) color_set(0,0,1);
      }
      plot_rectangle_fill(x[i]-dx,y[j]-dy,x[i]+dx,y[j]+dy,n);
    }
  }

  XSetForeground(mydisplay,mygc,colorpixel);
}
void ventana::plot2d_colorx(int nx1,int ny1,int nx2,int ny2,double xmin,double xmax,string s){
  int j1 = height-ny1;
  int j2 = height-ny2;
  double b;
  for (int i=nx1;i<=nx2;i++){
    b  = double(i-nx1)/double(nx2-nx1);
    color_set(b,0,0);
    XDrawLine(mydisplay,mywindow,mygc,i,j1,i,j2);
  }
  color_set(1);
  plot_text(nx1,j1+twy,xmin);
  plot_text(nx2-twx,j1+twy,xmax);
  plot_text((nx2+nx1)/2,j1+twy,s);
  XSetForeground(mydisplay,mygc,colorpixel);
}
void ventana::plot2d_colory(int nx1,int ny1,int nx2,int ny2,double xmin,double xmax,string s){
  int j1 = height-ny1;
  int j2 = height-ny2;
  double b;
  for (int j=j2;j<=j1;j++){
    b  = double(j-j1)/double(j2-j1);
    color_set(b,0,0);
    XDrawLine(mydisplay,mywindow,mygc,nx1,j,nx2,j);
  }
  color_set(1);
  plot_text(nx2+3,j1,xmin);
  plot_text(nx2+3,j2,xmax);
  plot_text(nx2+3,(j2+j1)/2,s);
  for (int j=j1;j<j1+10;j++){
    color_set(0,0,1);
    XDrawLine(mydisplay,mywindow,mygc,nx1,j,nx2,j);
  }
  color_set(0,0,0);
  plot_rectangle(nx1,j1+10,nx2,j2-10);
  XSetForeground(mydisplay,mygc,colorpixel);
}







void ventana::plot2d_vec(double **vx,double **vy,int nx,int ny,double siz,int nave,int n){  
  double bx,by,xx,yy;

  if (nave<=1) {
    for (int i=0;i<nx;i+=nave){
      for (int j=0;j<ny;j+=nave){
	plot_arrow(i,j,i+vx[i][j]/siz,j+vy[i][j]/siz,0.3,n);
      }
    }
  } else {  
    for (int i=0;i<nx;i+=nave){
      for (int j=0;j<ny;j+=nave){  
	if (i+nave<=nx && j+nave<=ny){
	  bx = 0.0;
	  by = 0.0;
	  for (int i1=0;i1<nave;i1++){
	    for (int j1=0;j1<nave;j1++){
	      bx = bx + vx[i+i1][j+j1];
	      by = by + vy[i+i1][j+j1];
	    }
	  }
	  xx = i+nave/2.0;
	  yy = j+nave/2.0;
	  bx = xx+bx/(siz*double(nave*nave));
	  by = yy+by/(siz*double(nave*nave));
	  plot_arrow(xx,yy,bx,by,0.1*nave,n);
	} 
      }
    }
  }
}

void ventana::plot2d_vec(double **vx,double **vy,double *x,double *y,int nx,int ny,double siz,int nave,int n){  
  double bx,by,xx,yy;
  double sc;

  sc = sqrt((x[1]-x[0])*(x[1]-x[0])+(y[1]-y[0])*(y[1]-y[0]));
  sc = siz/sc;
  if (nave<=1) {
    for (int i=0;i<nx;i+=nave){
      for (int j=0;j<ny;j+=nave){
	plot_arrow(x[i],y[j],x[i]+vx[i][j]/sc,y[i]+vy[i][j]/sc,0.1/sc,n);
      }
    }
  } else {
    for (int i=0;i<nx;i+=nave){
      for (int j=0;j<ny;j+=nave){  
	if (i+nave<nx && j+nave<ny){
	  bx = 0.0;
	  by = 0.0;
	  for (int i1=0;i1<nave;i1++){
	    for (int j1=0;j1<nave;j1++){
	      bx = bx + vx[i+i1][j+j1];
	      by = by + vy[i+i1][j+j1];
	    }
	  }
	  bx = bx/double(nave*nave);
	  by = by/double(nave*nave);
	  xx = (x[i]+x[i+nave])/2.0;
	  yy = (y[j]+y[j+nave])/2.0;
	  bx = xx+bx/sc;
	  by = yy+by/sc;
	  plot_arrow(xx,yy,bx,by,0.3,n);
	}   
      } 
    }
  }
}
  

//////////////////////////////////////////
// MULTIPURPOSE FUNCTIONS
//////////////////////////////////////////

void ventana::flush(){ 
  XFlush(mydisplay);
}


void ventana::save(string t){
  string s="import -silent -window ";
  s=s+dec(winID);
  s=s+" ";
  s=s+t;
  cout<<s<<endl;
  system(s.c_str());
}

void ventana::clean(int n){
  if (n >= numgraph){
    cout << " Error en numero de graficos"<< endl; 
    exit(0);
  }
  if (n==0) XClearWindow(mydisplay,mywindow);
  else clean(xiP[n]-twx,yfP[n]-1,xfP[n]+1,yiP[n]+twy);
}
void ventana::clean(int xi,int yi,int xf,int yf){
   XClearArea(mydisplay,mywindow,xi,yi,xf-xi,yf-yi,0);
}



void ventana::wait(){
  XSelectInput(mydisplay, mywindow,  ExposureMask | KeyPressMask | ButtonPressMask);
  XEvent myevent;
  int done = 0;
  while (done == 0) {
    XNextEvent(mydisplay, &myevent);
    switch(myevent.type) {
      case Expose:{
	;
      }
      break;
      case KeyPress:{
	done=1;
      }
      break;
      case ButtonPress:{
	if (myevent.xbutton.button==3) {
	    string s="menu.wish ";
	    s=s+dec(winID);
	    system(s.c_str());
	}
      }
    }
  }
}



void ventana::wait(double tval){
  flush();
  usleep(int(100000*tval));
}
